from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator

def getDescription():
	return "Zufallsgenerierte Inseln auf einer Seite der Erde (Norden oder Sden). Entsprechend sind die Klima-Verhltnisse."
	
def isAdvancedMap():
	"This map should show up in simple mode"
	return 0

def getNumCustomMapOptions():
	return 1
	
def getCustomMapOptionName(argsList):
	translated_text = unicode(CyTranslator().getText("Hemisphere", ()))
	return translated_text
	
def getNumCustomMapOptionValues(argsList):
	return 2
	
def getCustomMapOptionDescAt(argsList):
	iSelection = argsList[1]
	selection_names = ["Nordhalbkugel",
	                   "Sdhalbkugel"]
	translated_text = unicode(CyTranslator().getText(selection_names[iSelection], ()))
	return translated_text
	
def getCustomMapOptionDefault(argsList):
	return 0

def getWrapX():
	return false
	
def getWrapY():
	return false

def generatePlotTypes():
	NiTextOut("Setting Plot Types (Python Fractal) ...")
	fractal_world = FractalWorld( 4, 4 )
	fractal_world.initFractal(continent_grain = 4, rift_grain = -1, polar = False)
	retVal = fractal_world.generatePlotTypes(water_percent = 60)
	sinkEasternShore(fractal_world, 4)
        sinkWesternShore(fractal_world, 4)
	return retVal

def generateTerrainTypes():
	NiTextOut("Generating Terrain (Python Fractal) ...")
	terraingen = hemispherical_terrain(iMarshPercent=20, grain_amount=6)
	terrainTypes = terraingen.generateTerrain()
	return terrainTypes

def addFeatures():
	NiTextOut("Adding Features (Python Fractal) ...")
	featuregen = hemispherical_features(iJunglePercent=50, iForestPercent=99, iLightForestPercent=30)
	featuregen.addFeatures()
	return 0
	
def sinkEasternShore(fractal_world, iWidth):
	for x in range(iWidth):
		for y in range(fractal_world.iNumPlotsY):
			i = y * fractal_world.iNumPlotsX + fractal_world.iNumPlotsX - 1 - x 
			fractal_world.plotTypes[i] = PlotTypes.PLOT_OCEAN
				
	return 0

def sinkWesternShore(fractal_world, iWidth):
	for x in range(iWidth):
		for y in range(fractal_world.iNumPlotsY):
			i = y * fractal_world.iNumPlotsX + x 
			fractal_world.plotTypes[i] = PlotTypes.PLOT_OCEAN
				
	return 0



class hemispherical_terrain(TerrainGenerator):

	def getLatitudeAtPlot(self, iX, iY):

                lat = (float(iY) / float(self.iHeight)) - .15  # fudge a little for more tropics

		if (self.map.getCustomMapOption(0) == 1):  # southern hemisphere
			lat = 1.0 - (lat + .3)

		# Adjust latitude using self.variation fractal, to mix things up:
		lat += (128 - self.variation.getHeight(iX, iY))/(255.0 * 5.0)

		# Limit to the range [0, 1]:
		if lat < 0:
			lat = 0.0
		if lat > 1:
			lat = 1.0

		return lat


class hemispherical_features(FeatureGenerator):


	def getLatitudeAtPlot(self, iX, iY):
		if (self.map.getCustomMapOption(0) == 1):  # southern hemisphere
			return 1.0 - ((float(iY) / float(self.map.getGridHeight())) + .15)
		else:
                        return ((float(iY) / float(self.map.getGridHeight())) - .15)

	def addForestsAtPlot(self, pPlot, iX, iY, lat):
                if (lat > .1):  # remove pesky evergreen forests from the tropics
			if pPlot.canHaveFeature(self.featureForest):
				if self.forests.getHeight(iX, iY) >= self.iForestLevel:
					pPlot.setFeatureType(self.featureForest, -1)

	def addIceAtPlot(self, pPlot, iX, iY, lat):

                lat += .175
		if pPlot.canHaveFeature(self.featureIce):
			if (self.map.isWrapX() and not self.map.isWrapY()) and (iY == 0 or iY == self.iGridH - 1):
				pPlot.setFeatureType(self.featureIce, -1)
			elif (self.map.isWrapY() and not self.map.isWrapX()) and (iX == 0 or iX == self.iGridW - 1):
				pPlot.setFeatureType(self.featureIce, -1)
			else:
				rand = self.mapRand.get(100, "Add Ice PYTHON")/100.0
				if rand < 8 * (lat - (1.0 - (self.gc.getClimateInfo(self.map.getClimate()).getRandIceLatitude() / 2.0))):
					pPlot.setFeatureType(self.featureIce, -1)
				elif rand < 4 * (lat - (1.0 - self.gc.getClimateInfo(self.map.getClimate()).getRandIceLatitude())):
					pPlot.setFeatureType(self.featureIce, -1)
